/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.wizards;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ProcessStatus;
import com.aptana.git.ui.CloneJob;
import com.aptana.git.ui.GitUIPlugin;
import com.aptana.git.ui.internal.wizards.Messages;
import com.aptana.git.ui.internal.wizards.RepositorySelectionPage;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class CloneWizard
extends Wizard
implements IImportWizard {
    private RepositorySelectionPage cloneSource;

    public boolean performFinish() {
        final String sourceURI = this.cloneSource.getSource();
        final String dest = this.cloneSource.getDestination();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    CloneJob job = new CloneJob(sourceURI, dest);
                    IStatus status = job.run(monitor);
                    if (!status.isOK()) {
                        if (status instanceof ProcessStatus) {
                            ProcessStatus ps = (ProcessStatus)status;
                            String stderr = ps.getStdErr();
                            throw new InvocationTargetException(new CoreException((IStatus)new Status(status.getSeverity(), status.getPlugin(), stderr)));
                        }
                        throw new InvocationTargetException(new CoreException(status));
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                CoreException ce = (CoreException)e.getCause();
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.CloneWizard_CloneFailedTitle, (String)ce.getMessage());
            } else {
                IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
            }
        }
        catch (InterruptedException e) {
            IdeLog.logError((Plugin)GitUIPlugin.getDefault(), (Throwable)e, (String)"com.aptana.git.core/debug");
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.cloneSource = new RepositorySelectionPage();
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.cloneSource);
    }
}

